package de.jaggl.utils.common.helpers.swing;

import static java.io.File.separator;

public class JarHelper
{

    public static String currentJar()
    {
        return JarHelper.class.getProtectionDomain()
            .getCodeSource().getLocation().getPath();
    }

    public static boolean isJar()
    {
        return currentJar().endsWith(".jar");
    }

    public static void restartApplication() throws Exception
    {
        if (isJar())
        {
            String javaBin = System.getProperty("java.home") + separator
                + "bin" + separator + "java";
            new ProcessBuilder(javaBin, "-jar", currentJar()).start();
            System.exit(0);
        }
    }

}
