/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers;

import de.jaggl.utils.common.helpers.PreferencesHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LanguageHelper {
    private static Log log = LogFactory.getLog(LanguageHelper.class);
    private static Properties fallback;
    private static Properties properties;
    private static Map<String, String> mappedLanguages;
    private static Map<String, String> reverseMappedLanguages;

    public static String getText(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            value = fallback.getProperty(key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static Set<String> getAvailableLanguages() {
        return mappedLanguages.keySet();
    }

    public static String getCurrentLanguage() {
        return reverseMappedLanguages.get(PreferencesHelper.pref("lang", "en"));
    }

    public static void setCurrentLanguage(String langName) {
        PreferencesHelper.setPref("lang", mappedLanguages.get(langName));
        LanguageHelper.loadCurrentLanguage();
    }

    private static void searchForAvailableLanguages() {
        mappedLanguages.clear();
        reverseMappedLanguages.clear();
        mappedLanguages.put("English", "en");
        mappedLanguages.put("Deutsch", "de");
        reverseMappedLanguages.put("en", "English");
        reverseMappedLanguages.put("de", "Deutsch");
        Map<String, String> languageFiles = LanguageHelper.findLanguageFiles();
        reverseMappedLanguages.putAll(languageFiles);
        for (Map.Entry<String, String> entry : languageFiles.entrySet()) {
            mappedLanguages.put(entry.getValue(), entry.getKey());
        }
    }

    private static void loadFallbackLanguage() {
        fallback = new Properties();
        try {
            fallback.load(LanguageHelper.getResource("lang_en.properties"));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void loadCurrentLanguage() {
        String lang = PreferencesHelper.pref("lang", "en");
        properties = new Properties();
        try {
            if (LanguageHelper.resourceExists("lang_" + lang + ".properties")) {
                properties.load(LanguageHelper.getResource("lang_" + lang + ".properties"));
            } else {
                properties.load(new FileInputStream(new File("./lang/lang_" + lang + ".properties")));
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, String> findLanguageFiles() {
        HashMap<String, String> foundFiles = new HashMap<String, String>();
        try {
            File[] files;
            for (File file : files = new File("./lang").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("^lang_[a-z]{2}\\.properties$");
                }
            })) {
                String key = file.getName().replaceAll("^lang_", "").replaceAll("\\.properties", "");
                Properties properties = new Properties();
                try {
                    properties.load(new FileInputStream(file));
                    String value = properties.getProperty("language");
                    if (value == null) continue;
                    foundFiles.put(key, value);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
        return foundFiles;
    }

    private static boolean resourceExists(String resource) {
        return LanguageHelper.class.getClassLoader().getResource(resource) != null;
    }

    private static InputStream getResource(String resource) {
        return LanguageHelper.class.getClassLoader().getResourceAsStream(resource);
    }

    static {
        mappedLanguages = new HashMap<String, String>();
        reverseMappedLanguages = new HashMap<String, String>();
        LanguageHelper.loadCurrentLanguage();
        LanguageHelper.loadFallbackLanguage();
        LanguageHelper.searchForAvailableLanguages();
    }
}

