package de.jaggl.utils.common.helpers;

import static de.jaggl.utils.common.helpers.ListHelper.addFirstToArray;
import static de.jaggl.utils.common.helpers.ListHelper.implodeArray;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandLineHelper
{

    private static final Log log = LogFactory.getLog(CommandLineHelper.class);

    public static void execute(String command, String... args) throws Exception
    {
        String[] commands = addFirstToArray(args, command);
        String commandLine = implodeArray(" ", commands);

        log.debug("executing: " + commandLine);
        try
        {
            Process pr = Runtime.getRuntime().exec(commandLine);

            BufferedReader input = new BufferedReader(new InputStreamReader(
                pr.getInputStream()));

            String line = null;
            while ((line = input.readLine()) != null)
            {
                log.debug(line);
            }

            int exitVal = pr.waitFor();
            log.debug("Exited with error code " + exitVal);
        }
        catch (Exception e)
        {
            throw new Exception("Error when trying to execute the command '"
                + commandLine + "'", e);
        }
    }
}
