package de.jaggl.utils.common.helpers;

import static de.jaggl.utils.common.helpers.ListHelper.convertAll;
import static java.util.Arrays.asList;

import java.util.List;

import de.jaggl.utils.common.helpers.ListHelper.Converter;

public class EnumHelper
{

    public static <T extends Enum<?>> List<String> getEnumNames(List<T> values)
    {
        return convertAll(values, new Converter<T, String>()
        {
            @Override
            public String convert(T enumValue)
            {
                return enumValue.name();
            }
        });
    }

    @SafeVarargs
    public static <T extends Enum<?>> List<String> getEnumNames(T... values)
    {
        return getEnumNames(asList(values));
    }

}
