package de.jaggl.utils.common.helpers;

import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder
{

    public static <K, V> ExplicitMapBuilder<K, V> put(K key, V value)
    {
        return new ExplicitMapBuilder<K, V>(key, value);
    }

    public static <K, V> Map<K, V> entry(K key, V value)
    {
        return put(key, value).build();
    }

    public static <K, V> ExplicitMapBuilder<K, V> extend(Map<K, V> map)
    {
        return new ExplicitMapBuilder<K, V>(map);
    }

    public static class ExplicitMapBuilder<K, V>
    {

        private final Map<K, V> map;

        private ExplicitMapBuilder(Map<K, V> map)
        {
            this.map = new LinkedHashMap<K, V>(map);
        }

        private ExplicitMapBuilder(K key, V value)
        {
            map = new LinkedHashMap<K, V>();
            map.put(key, value);
        }

        public ExplicitMapBuilder<K, V> put(K key, V value)
        {
            map.put(key, value);
            return this;
        }

        public Map<K, V> build()
        {
            return map;
        }

    }

}
