package de.jaggl.utils.common.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class MapHelper
{

    public static <T, E> List<T> getKeysWithNullValues(
        Map<T, E> allIdSets)
    {
        List<T> keys = new ArrayList<T>();
        Iterator<Entry<T, E>> it = allIdSets.entrySet().iterator();
        while (it.hasNext())
        {
            Entry<T, E> entry = it.next();
            if (entry.getValue() == null)
            {
                keys.add(entry.getKey());
            }
        }
        return keys;
    }

    @SafeVarargs
    public static <T, E> Map<T, E> removeAll(Map<T, E> map, T... keys)
    {
        for (T key : keys)
        {
            map.remove(key);
        }
        return map;
    }

}
