package de.jaggl.utils.common.helpers;

import static java.util.Arrays.asList;

import java.util.List;

public class TypeHelper
{

    public static boolean isOneOf(Boolean source, boolean... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Byte source, byte... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Character source, char... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Double source, double... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Float source, float... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Integer source, int... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Short source, short... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Long source, long... values)
    {
        return isOneOfObjects(source, (Object[]) toObjectArray(values));
    }

    public static boolean isOneOf(Enum<?> source, Enum<?>... values)
    {
        return isOneOfObjects(source, (Object[]) values);
    }

    public static boolean isOneOf(String source, String... values)
    {
        return isOneOfObjects(source, (Object[]) values);
    }

    @SafeVarargs
    public static <E> boolean isAssignableToAnyOf(E object,
        Class<? extends E>... types)
    {
        for (Class<? extends E> type : types)
        {
            if (type != null && type.isAssignableFrom(object.getClass()))
            {
                return true;
            }
        }
        return false;
    }

    public static boolean isOneOfObjects(Object source, Object... values)
    {
        if (values == null)
        {
            return false;
        }
        return asList(values).contains(source);
    }

    public static Boolean[] toObjectArray(boolean... values)
    {
        if (values == null)
        {
            return new Boolean[0];
        }
        Boolean[] array = new Boolean[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Boolean.valueOf(values[i]);
        }
        return array;
    }

    public static Byte[] toObjectArray(byte... values)
    {
        if (values == null)
        {
            return new Byte[0];
        }
        Byte[] array = new Byte[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Byte.valueOf(values[i]);
        }
        return array;
    }

    public static Character[] toObjectArray(char... values)
    {
        if (values == null)
        {
            return new Character[0];
        }
        Character[] array = new Character[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static Double[] toObjectArray(double... values)
    {
        if (values == null)
        {
            return new Double[0];
        }
        Double[] array = new Double[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Double.valueOf(values[i]);
        }
        return array;
    }

    public static Float[] toObjectArray(float... values)
    {
        if (values == null)
        {
            return new Float[0];
        }
        Float[] array = new Float[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static Integer[] toObjectArray(int... values)
    {
        if (values == null)
        {
            return new Integer[0];
        }
        Integer[] array = new Integer[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Integer.valueOf(values[i]);
        }
        return array;
    }

    public static Short[] toObjectArray(short... values)
    {
        if (values == null)
        {
            return new Short[0];
        }
        Short[] array = new Short[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Short.valueOf(values[i]);
        }
        return array;
    }

    public static Long[] toObjectArray(long... values)
    {
        if (values == null)
        {
            return new Long[0];
        }
        Long[] array = new Long[values.length];
        for (int i = 0; i < values.length; i++)
        {
            array[i] = Long.valueOf(values[i]);
        }
        return array;
    }

    public static List<Boolean> toObjectList(boolean... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Byte> toObjectList(byte... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Character> toObjectList(char... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Double> toObjectList(double... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Float> toObjectList(float... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Integer> toObjectList(int... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Long> toObjectList(long... values)
    {
        return asList(toObjectArray(values));
    }

    public static List<Short> toObjectList(short... values)
    {
        return asList(toObjectArray(values));
    }

}
