package de.jaggl.utils.common.helpers.swing;

import static javax.imageio.ImageIO.read;

import java.awt.Image;
import java.awt.Window;
import java.lang.reflect.Method;

public class AppleHelper
{

    public static void initialize(String applicationName,
        String dockIconResourcePath)
    {
        setApplicationName(applicationName);
        enableScreenMenuBar();
        disableAboutMenu();
        setDockIcon(dockIconResourcePath);
    }

    public static void setApplicationName(String applicationName)
    {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name",
            applicationName);
    }

    public static void enableScreenMenuBar()
    {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public static void setFullscreen(Window window)
    {
        try
        {
            Class<?> clazz = loadClass("com.apple.eawt.FullScreenUtilities");
            Method method = clazz.getMethod("setWindowCanFullScreen",
                Window.class, boolean.class);
            method.invoke(null, window, Boolean.TRUE);
        }
        catch (Exception e)
        {
        }
    }

    public static void disableAboutMenu()
    {
        try
        {
            Object application = getApplication();
            Method method = application.getClass().getMethod(
                "setEnabledAboutMenu", boolean.class);
            method.invoke(application, Boolean.FALSE);
        }
        catch (Exception e)
        {
        }
    }

    public static void setDockIcon(String dockIconResourcePath)
    {
        try
        {
            Image image = read(getClassLoader().getResource(
                dockIconResourcePath));
            Object application = getApplication();
            Method method = application.getClass().getMethod(
                "setDockIconImage", Image.class);

            method.invoke(application, image);
        }
        catch (Exception e)
        {
        }
    }

    private static Object getApplication() throws Exception
    {
        Class<?> clazz = loadClass("com.apple.eawt.Application");
        Method method = clazz.getMethod("getApplication");
        return method.invoke(null);
    }

    private static ClassLoader getClassLoader()
    {
        return AppleHelper.class.getClassLoader();
    }

    private static Class<?> loadClass(String name)
        throws ClassNotFoundException
    {
        return getClassLoader().loadClass(name);
    }

}
