package de.jaggl.utils.common.helpers.swing;

import static javax.swing.Spring.constant;
import static javax.swing.Spring.max;
import static javax.swing.Spring.sum;
import static javax.swing.SpringLayout.EAST;
import static javax.swing.SpringLayout.SOUTH;

import java.awt.Component;
import java.awt.Container;

import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringLayoutHelper
{

    public static void makeGrid(Container parent,
        int rows, int cols,
        int initialX, int initialY,
        int xPad, int yPad)
    {
        SpringLayout layout;
        try
        {
            layout = (SpringLayout) parent.getLayout();
        }
        catch (ClassCastException exc)
        {
            System.err
                .println("The first argument to makeGrid must use SpringLayout.");
            return;
        }

        Spring xPadSpring = constant(xPad);
        Spring yPadSpring = constant(yPad);
        Spring initialXSpring = constant(initialX);
        Spring initialYSpring = constant(initialY);
        int max = rows * cols;

        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).
            getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).
            getHeight();
        for (int i = 1; i < max; i++)
        {
            SpringLayout.Constraints cons = layout.getConstraints(
                parent.getComponent(i));

            maxWidthSpring = max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = max(maxHeightSpring, cons.getHeight());
        }

        for (int i = 0; i < max; i++)
        {
            SpringLayout.Constraints cons = layout.getConstraints(
                parent.getComponent(i));

            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }

        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        for (int i = 0; i < max; i++)
        {
            SpringLayout.Constraints cons = layout.getConstraints(
                parent.getComponent(i));
            if (i % cols == 0)
            {
                lastRowCons = lastCons;
                cons.setX(initialXSpring);
            }
            else
            {
                cons.setX(sum(lastCons.getConstraint(EAST), xPadSpring));
            }

            if (i / cols == 0)
            {
                cons.setY(initialYSpring);
            }
            else
            {
                cons.setY(sum(lastRowCons.getConstraint(SOUTH),
                    yPadSpring));
            }
            lastCons = cons;
        }

        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint(SOUTH,
            sum(constant(yPad), lastCons.getConstraint(SOUTH)));
        pCons.setConstraint(EAST,
            sum(constant(xPad), lastCons.getConstraint(EAST)));
    }

    private static SpringLayout.Constraints getConstraintsForCell(
        int row, int col,
        Container parent,
        int cols)
    {
        SpringLayout layout = (SpringLayout) parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent,
        int rows, int cols,
        int initialX, int initialY,
        int xPad, int yPad)
    {
        SpringLayout layout;
        try
        {
            layout = (SpringLayout) parent.getLayout();
        }
        catch (ClassCastException exc)
        {
            System.err
                .println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }

        Spring x = constant(initialX);
        for (int c = 0; c < cols; c++)
        {
            Spring width = constant(0);
            for (int r = 0; r < rows; r++)
            {
                width = max(width,
                    getConstraintsForCell(r, c, parent, cols).
                        getWidth());
            }
            for (int r = 0; r < rows; r++)
            {
                SpringLayout.Constraints constraints =
                    getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = sum(x, sum(width, constant(xPad)));
        }

        Spring y = constant(initialY);
        for (int r = 0; r < rows; r++)
        {
            Spring height = constant(0);
            for (int c = 0; c < cols; c++)
            {
                height = max(height,
                    getConstraintsForCell(r, c, parent, cols).
                        getHeight());
            }
            for (int c = 0; c < cols; c++)
            {
                SpringLayout.Constraints constraints =
                    getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = sum(y, sum(height, constant(yPad)));
        }

        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint(SOUTH, y);
        pCons.setConstraint(EAST, x);
    }
}