package de.jaggl.utils.common.helpers.swing;

import static java.awt.Toolkit.getDefaultToolkit;
import static java.awt.event.KeyEvent.VK_ESCAPE;
import static java.awt.event.WindowEvent.WINDOW_CLOSING;
import static javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW;
import static javax.swing.KeyStroke.getKeyStroke;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class WindowHelper
{

    private static final String ESC = "ESCAPE";

    public static void closeOnExcape(final JDialog dialog)
    {
        KeyStroke escKeyStroke = getKeyStroke(VK_ESCAPE, 0, false);
        dialog.getRootPane().getInputMap(WHEN_IN_FOCUSED_WINDOW)
            .put(escKeyStroke, ESC);
        dialog.getRootPane().getActionMap().put(ESC, new AbstractAction()
        {
            private static final long serialVersionUID = 5553616636637049171L;

            @Override
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispatchEvent(new WindowEvent(dialog, WINDOW_CLOSING));
            }
        });
    }

    public static void setFullscreen(JFrame frame)
    {
        Dimension screenSize = getDefaultToolkit().getScreenSize();
        Insets insets = getDefaultToolkit().getScreenInsets(
            frame.getGraphicsConfiguration());
        Point location = new Point(insets.left, insets.top);
        Dimension size = new Dimension(screenSize.width - insets.left
            - insets.right, screenSize.height - insets.top - insets.bottom);
        frame.setLocation(location);
        frame.setSize(size);
    }

}
