/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;

public class ListHelper {
    public static <S, T> List<T> convertAll(List<S> sourceItems, Converter<S, T> converter) {
        ArrayList<T> targetList = new ArrayList<T>();
        for (S sourceItem : sourceItems) {
            targetList.add(converter.convert(sourceItem));
        }
        return targetList;
    }

    public static <T> Collection<T> removeNullValues(Collection<T> items) {
        ArrayList<T> collection = new ArrayList<T>(items);
        collection.removeAll(Collections.singleton(null));
        return collection;
    }

    public static <T> Collection<Collection<T>> divideInParts(Collection<T> items, int maxItems) {
        if (maxItems <= 0) {
            throw new ArithmeticException("maxItems must be greater than 0");
        }
        ArrayList<Collection<T>> parts = new ArrayList<Collection<T>>();
        if (items == null) {
            return parts;
        }
        int count = items.size() / maxItems;
        count = items.size() % maxItems != 0 ? count + 1 : count;
        for (int i = 0; i < count; ++i) {
            int fromIndex = i * maxItems;
            int toIndex = (i + 1) * maxItems;
            toIndex = toIndex > items.size() ? items.size() : toIndex;
            List<T> part = new ArrayList<T>(items).subList(fromIndex, toIndex);
            parts.add(part);
        }
        return parts;
    }

    public static <T> Collection<T> merge(Collection<Collection<T>> lists) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (lists == null) {
            return resultList;
        }
        for (Collection<T> list : lists) {
            if (list == null) continue;
            resultList.addAll(list);
        }
        return resultList;
    }

    @SafeVarargs
    public static <T> boolean inList(T value, T ... list) {
        if (value == null) {
            return false;
        }
        for (T item : list) {
            if (item == null || !value.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static <E> String implodeList(String glue, Collection<E> list) {
        if (list == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (E value : list) {
            builder.append(value);
            if (++i >= list.size()) continue;
            builder.append(glue);
        }
        return builder.toString();
    }

    public static String implodeArgs(String glue, Object ... args) {
        return ListHelper.implodeList(glue, Arrays.asList(args));
    }

    public static String implodeArray(String glue, Object[] args) {
        return ListHelper.implodeList(glue, Arrays.asList(args));
    }

    public static <T> Collection<T> getElements(ListModel<T> listModel) {
        ArrayList<T> elements = new ArrayList<T>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            elements.add(listModel.getElementAt(i));
        }
        return elements;
    }

    public static <E> Collection<E> multiplyEntries(Collection<E> list, int factor) {
        if (list == null) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>();
        for (E entry : list) {
            for (int i = 0; i < factor; ++i) {
                result.add(entry);
            }
        }
        return result;
    }

    public static <E> E[] addFirstToArray(E[] array, E value) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(value);
        list.addAll(Arrays.asList(array));
        return list.toArray(array);
    }

    @SafeVarargs
    public static <T> T[] addToArray(T[] args, T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(Arrays.asList(args));
        for (T value : values) {
            list.add(value);
        }
        return list.toArray(args);
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... values) {
        return values;
    }

    public static interface Converter<S, T> {
        public T convert(S var1);
    }
}

