/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers;

import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder {
    public static <K, V> ExplicitMapBuilder<K, V> put(K key, V value) {
        return new ExplicitMapBuilder(key, value);
    }

    public static <K, V> Map<K, V> entry(K key, V value) {
        return MapBuilder.put(key, value).build();
    }

    public static <K, V> ExplicitMapBuilder<K, V> extend(Map<K, V> map) {
        return new ExplicitMapBuilder(map);
    }

    public static class ExplicitMapBuilder<K, V> {
        private final Map<K, V> map;

        private ExplicitMapBuilder(Map<K, V> map) {
            this.map = new LinkedHashMap<K, V>(map);
        }

        private ExplicitMapBuilder(K key, V value) {
            this.map = new LinkedHashMap();
            this.map.put(key, value);
        }

        public ExplicitMapBuilder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Map<K, V> build() {
            return this.map;
        }
    }
}

