/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers;

import java.util.Arrays;
import java.util.List;

public class TypeHelper {
    public static boolean isOneOf(Boolean source, boolean ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Byte source, byte ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Character source, char ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Double source, double ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Float source, float ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Integer source, int ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Short source, short ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Long source, long ... values) {
        return TypeHelper.isOneOfObjects(source, TypeHelper.toObjectArray(values));
    }

    public static boolean isOneOf(Enum<?> source, Enum<?> ... values) {
        return TypeHelper.isOneOfObjects(source, values);
    }

    public static boolean isOneOf(String source, String ... values) {
        return TypeHelper.isOneOfObjects(source, values);
    }

    @SafeVarargs
    public static <E> boolean isAssignableToAnyOf(E object, Class<? extends E> ... types) {
        for (Class<E> clazz : types) {
            if (clazz == null || !clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOfObjects(Object source, Object ... values) {
        if (values == null) {
            return false;
        }
        return Arrays.asList(values).contains(source);
    }

    public static Boolean[] toObjectArray(boolean ... values) {
        if (values == null) {
            return new Boolean[0];
        }
        Boolean[] array = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Byte[] toObjectArray(byte ... values) {
        if (values == null) {
            return new Byte[0];
        }
        Byte[] array = new Byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] toObjectArray(char ... values) {
        if (values == null) {
            return new Character[0];
        }
        Character[] array = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static Double[] toObjectArray(double ... values) {
        if (values == null) {
            return new Double[0];
        }
        Double[] array = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] toObjectArray(float ... values) {
        if (values == null) {
            return new Float[0];
        }
        Float[] array = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static Integer[] toObjectArray(int ... values) {
        if (values == null) {
            return new Integer[0];
        }
        Integer[] array = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] toObjectArray(short ... values) {
        if (values == null) {
            return new Short[0];
        }
        Short[] array = new Short[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] toObjectArray(long ... values) {
        if (values == null) {
            return new Long[0];
        }
        Long[] array = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static List<Boolean> toObjectList(boolean ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Byte> toObjectList(byte ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Character> toObjectList(char ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Double> toObjectList(double ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Float> toObjectList(float ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Integer> toObjectList(int ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Long> toObjectList(long ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }

    public static List<Short> toObjectList(short ... values) {
        return Arrays.asList(TypeHelper.toObjectArray(values));
    }
}

