package de.jaggl.dto.converters;

import static de.jaggl.dto.Dto.fromXml;
import static org.springframework.http.MediaType.APPLICATION_XML;

import java.io.IOException;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

import de.jaggl.dto.Dto;

public class DtoHttpMessageConverter extends AbstractHttpMessageConverter<Dto>
{

    public DtoHttpMessageConverter()
    {
        super(APPLICATION_XML);
    }

    @Override
    protected boolean supports(Class<?> clazz)
    {
        return Dto.class.isAssignableFrom(clazz);
    }

    @Override
    protected Dto readInternal(Class<? extends Dto> clazz,
        HttpInputMessage inputMessage) throws IOException,
        HttpMessageNotReadableException
    {
        return fromXml(inputMessage.getBody());
    }

    @Override
    protected void writeInternal(Dto dto, HttpOutputMessage outputMessage)
        throws IOException, HttpMessageNotWritableException
    {
        dto.toXml(outputMessage.getBody());
    }

}
