package de.jaggl.dto.converters;

import static de.jaggl.dto.Dto.fromXml;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

import de.jaggl.dto.Dto;

public class DtoMessageConverter implements MessageConverter
{

    @Override
    public Message toMessage(Object object, Session session)
        throws JMSException, MessageConversionException
    {
        return session.createTextMessage(((Dto) object).toXml());
    }

    @Override
    public Object fromMessage(Message message) throws JMSException,
        MessageConversionException
    {
        return fromXml(((TextMessage) message).getText());
    }

}
