package de.jaggl.dto;

import static de.jaggl.utils.common.helpers.ReflectionHelper.getFieldData;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map.Entry;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.exception.UnexpectedTypeException;
import de.jaggl.dto.helpers.XmlConverter;
import de.jaggl.dto.lists.AbstractList;
import de.jaggl.dto.lists.BooleanList;
import de.jaggl.dto.lists.ByteList;
import de.jaggl.dto.lists.CharacterList;
import de.jaggl.dto.lists.DoubleList;
import de.jaggl.dto.lists.DtoList;
import de.jaggl.dto.lists.FloatList;
import de.jaggl.dto.lists.IntegerList;
import de.jaggl.dto.lists.LongList;
import de.jaggl.dto.lists.PrimitiveList;
import de.jaggl.dto.lists.ShortList;
import de.jaggl.dto.lists.StringList;

@XStreamAlias("dto")
public final class Dto implements Iterable<Entry<String, Object>>
{

    private LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();

    public void put(String key, byte value)
    {
        putData(key, Byte.valueOf(value));
    }

    public void put(String key, boolean value)
    {
        putData(key, Boolean.valueOf(value));
    }

    public void put(String key, short value)
    {
        putData(key, Short.valueOf(value));
    }

    public void put(String key, int value)
    {
        putData(key, Integer.valueOf(value));
    }

    public void put(String key, long value)
    {
        putData(key, Long.valueOf(value));
    }

    public void put(String key, float value)
    {
        putData(key, Float.valueOf(value));
    }

    public void put(String key, double value)
    {
        putData(key, Double.valueOf(value));
    }

    public void put(String key, char value)
    {
        putData(key, Character.valueOf(value));
    }

    public void put(String key, String value)
    {
        putData(key, value);
    }

    public void put(String key, Dto value)
    {
        putData(key, value);
    }

    public void put(String key, ByteList value)
    {
        putData(key, value);
    }

    public void put(String key, BooleanList value)
    {
        putData(key, value);
    }

    public void put(String key, ShortList value)
    {
        putData(key, value);
    }

    public void put(String key, IntegerList value)
    {
        putData(key, value);
    }

    public void put(String key, LongList value)
    {
        putData(key, value);
    }

    public void put(String key, FloatList value)
    {
        putData(key, value);
    }

    public void put(String key, DoubleList value)
    {
        putData(key, value);
    }

    public void put(String key, CharacterList value)
    {
        putData(key, value);
    }

    public void put(String key, StringList value)
    {
        putData(key, value);
    }

    public void put(String key, DtoList value)
    {
        putData(key, value);
    }

    public void put(String key, PrimitiveList value)
    {
        putData(key, value);
    }

    public void put(String key, byte... values)
    {
        putData(key, new ByteList(values));
    }

    public void put(String key, boolean... values)
    {
        putData(key, new BooleanList(values));
    }

    public void put(String key, short... values)
    {
        putData(key, new ShortList(values));
    }

    public void put(String key, int... values)
    {
        putData(key, new IntegerList(values));
    }

    public void put(String key, long... values)
    {
        putData(key, new LongList(values));
    }

    public void put(String key, float... values)
    {
        putData(key, new FloatList(values));
    }

    public void put(String key, double... values)
    {
        putData(key, new DoubleList(values));
    }

    public void put(String key, char... values)
    {
        putData(key, new CharacterList(values));
    }

    public void put(String key, String... values)
    {
        putData(key, new StringList(values));
    }

    public void put(String key, Dto... values)
    {
        putData(key, new DtoList(values));
    }

    public void putNull(String key)
    {
        putData(key, null);
    }

    public Byte get(String key, byte defaultValue)
    {
        return getData(key, Byte.valueOf(defaultValue));
    }

    public Boolean get(String key, boolean defaultValue)
    {
        return getData(key, Boolean.valueOf(defaultValue));
    }

    public Short get(String key, short defaultValue)
    {
        return getData(key, Short.valueOf(defaultValue));
    }

    public Integer get(String key, int defaultValue)
    {
        return getData(key, Integer.valueOf(defaultValue));
    }

    public Long get(String key, long defaultValue)
    {
        return getData(key, Long.valueOf(defaultValue));
    }

    public Float get(String key, float defaultValue)
    {
        return getData(key, Float.valueOf(defaultValue));
    }

    public Double get(String key, double defaultValue)
    {
        return getData(key, Double.valueOf(defaultValue));
    }

    public Character get(String key, char defaultValue)
    {
        return getData(key, Character.valueOf(defaultValue));
    }

    public String get(String key, String defaultValue)
    {
        return getData(key, defaultValue);
    }

    public Dto get(String key, Dto defaultValue)
    {
        return getData(key, defaultValue);
    }

    public List<Byte> get(String key, ByteList defaultValue)
    {
        return getList(key, defaultValue, ByteList.class);
    }

    public List<Boolean> get(String key, BooleanList defaultValue)
    {
        return getList(key, defaultValue, BooleanList.class);
    }

    public List<Short> get(String key, ShortList defaultValue)
    {
        return getList(key, defaultValue, ShortList.class);
    }

    public List<Integer> get(String key, IntegerList defaultValue)
    {
        return getList(key, defaultValue, IntegerList.class);
    }

    public List<Long> get(String key, LongList defaultValue)
    {
        return getList(key, defaultValue, LongList.class);
    }

    public List<Float> get(String key, FloatList defaultValue)
    {
        return getList(key, defaultValue, FloatList.class);
    }

    public List<Double> get(String key, DoubleList defaultValue)
    {
        return getList(key, defaultValue, DoubleList.class);
    }

    public List<Character> get(String key, CharacterList defaultValue)
    {
        return getList(key, defaultValue, CharacterList.class);
    }

    public List<String> get(String key, StringList defaultValue)
    {
        return getList(key, defaultValue, StringList.class);
    }

    public List<Dto> get(String key, DtoList defaultValue)
    {
        return getList(key, defaultValue, DtoList.class);
    }

    public List<Object> get(String key, PrimitiveList defaultValue)
    {
        return getList(key, defaultValue, PrimitiveList.class);
    }

    public List<Byte> get(String key, byte... defaultValue)
    {
        return getList(key, new ByteList(defaultValue), ByteList.class);
    }

    public List<Boolean> get(String key, boolean... defaultValue)
    {
        return getList(key, new BooleanList(defaultValue), BooleanList.class);
    }

    public List<Short> get(String key, short... defaultValue)
    {
        return getList(key, new ShortList(defaultValue), ShortList.class);
    }

    public List<Integer> get(String key, int... defaultValue)
    {
        return getList(key, new IntegerList(defaultValue), IntegerList.class);
    }

    public List<Long> get(String key, long... defaultValue)
    {
        return getList(key, new LongList(defaultValue), LongList.class);
    }

    public List<Float> get(String key, float... defaultValue)
    {
        return getList(key, new FloatList(defaultValue), FloatList.class);
    }

    public List<Double> get(String key, double... defaultValue)
    {
        return getList(key, new DoubleList(defaultValue), DoubleList.class);
    }

    public List<Character> get(String key, char... defaultValue)
    {
        return getList(key, new CharacterList(defaultValue),
            CharacterList.class);
    }

    public List<String> get(String key, String... defaultValue)
    {
        return getList(key, new StringList(defaultValue), StringList.class);
    }

    public List<Dto> get(String key, Dto... defaultValue)
    {
        return getList(key, new DtoList(defaultValue), DtoList.class);
    }

    public Byte getByte(String key)
    {
        return get(key, Byte.class);
    }

    public Boolean getBoolean(String key)
    {
        return get(key, Boolean.class);
    }

    public Short getShort(String key)
    {
        return get(key, Short.class);
    }

    public Integer getInteger(String key)
    {
        return get(key, Integer.class);
    }

    public Long getLong(String key)
    {
        return get(key, Long.class);
    }

    public Float getFloat(String key)
    {
        return get(key, Float.class);
    }

    public Double getDouble(String key)
    {
        return get(key, Double.class);
    }

    public Character getCharacter(String key)
    {
        return get(key, Character.class);
    }

    public String getString(String key)
    {
        return get(key, String.class);
    }

    public Dto getDto(String key)
    {
        return get(key, Dto.class);
    }

    public List<Byte> getByteList(String key)
    {
        return getList(key, ByteList.class);
    }

    public List<Boolean> getBooleanList(String key)
    {
        return getList(key, BooleanList.class);
    }

    public List<Short> getShortList(String key)
    {
        return getList(key, ShortList.class);
    }

    public List<Integer> getIntegerList(String key)
    {
        return getList(key, IntegerList.class);
    }

    public List<Long> getLongList(String key)
    {
        return getList(key, LongList.class);
    }

    public List<Float> getFloatList(String key)
    {
        return getList(key, FloatList.class);
    }

    public List<Double> getDoubleList(String key)
    {
        return getList(key, DoubleList.class);
    }

    public List<Character> getCharacterList(String key)
    {
        return getList(key, CharacterList.class);
    }

    public List<String> getStringList(String key)
    {
        return getList(key, StringList.class);
    }

    public List<Dto> getDtoList(String key)
    {
        return getList(key, DtoList.class);
    }

    public List<Object> getPrimitiveList(String key)
    {
        return getList(key, PrimitiveList.class);
    }

    private void putData(String key, Object value)
    {
        if (key == null)
        {
            throw new NullPointerException("a DTO-key mustn't be null");
        }
        data.put(key, value);
    }

    public <T> T get(String key, Class<T> type)
    {
        Object value = data.get(key);
        if (value == null)
        {
            return null;
        }
        if (!(type.isAssignableFrom(value.getClass())))
        {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return type.cast(value);
    }

    @SuppressWarnings("unchecked")
    public <T> T getData(String key, T defaultValue)
    {
        if (!data.containsKey(key))
        {
            return defaultValue;
        }
        Object value = data.get(key);
        if (value == null)
        {
            return null;
        }
        if (!(defaultValue.getClass().isAssignableFrom(value.getClass())))
        {
            throw new UnexpectedTypeException(defaultValue.getClass(),
                value.getClass());
        }
        return (T) defaultValue.getClass().cast(value);
    }

    @SuppressWarnings("unchecked")
    private <T, E extends AbstractList<T>> List<T> getList(String key,
        Class<E> type)
    {
        Object value = data.get(key);
        if (value == null)
        {
            return null;
        }
        if (!(type.isAssignableFrom(value.getClass())))
        {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return (List<T>) getFieldData(value, "data");
    }

    @SuppressWarnings("unchecked")
    private <T, E extends AbstractList<T>> List<T> getList(String key,
        E defaultValue, Class<E> type)
    {
        if (!data.containsKey(key))
        {
            return (List<T>) getFieldData(defaultValue, "data");
        }
        Object value = data.get(key);
        if (value == null)
        {
            return null;
        }
        if (!(type.isAssignableFrom(value.getClass())))
        {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return (List<T>) getFieldData(value, "data");
    }

    public String toXml()
    {
        return XmlConverter.toXml(this);
    }

    public void toXml(OutputStream output)
    {
        XmlConverter.toXml(this, output);
    }

    public int size()
    {
        return data.size();
    }

    public boolean isEmpty()
    {
        return data.isEmpty();
    }

    public static Dto fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public static Dto fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public Iterator<Entry<String, Object>> iterator()
    {
        return data.entrySet().iterator();
    }

    @Override
    public String toString()
    {
        return String.format("Dto %s", data);
    }

}
