package de.jaggl.dto.converters;

import static de.jaggl.utils.common.helpers.ReflectionHelper.getFieldData;
import static de.jaggl.utils.common.helpers.ReflectionHelper.setFieldData;

import java.util.LinkedHashMap;
import java.util.Map;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import de.jaggl.dto.Dto;

public class DtoConverter implements Converter
{

    @Override
    public boolean canConvert(@SuppressWarnings("rawtypes") Class type)
    {
        return type.equals(Dto.class);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context)
    {
        Dto dto = (Dto) source;
        Map<String, Object> data = (Map<String, Object>) getFieldData(dto,
            "data");
        context.convertAnother(data);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader,
        UnmarshallingContext context)
    {
        Dto dto = new Dto();
        Object data = context.convertAnother(dto, LinkedHashMap.class);
        setFieldData(dto, "data", data);
        return dto;
    }

}
