/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.jaggl.dto.exception.UnexpectedTypeException;
import de.jaggl.dto.exception.UnsupportedTypeException;
import de.jaggl.dto.helpers.XmlConverter;
import de.jaggl.dto.lists.AbstractList;
import de.jaggl.dto.lists.BooleanList;
import de.jaggl.dto.lists.ByteList;
import de.jaggl.dto.lists.CharacterList;
import de.jaggl.dto.lists.DateList;
import de.jaggl.dto.lists.DoubleList;
import de.jaggl.dto.lists.DtoList;
import de.jaggl.dto.lists.FloatList;
import de.jaggl.dto.lists.IntegerList;
import de.jaggl.dto.lists.LongList;
import de.jaggl.dto.lists.PrimitiveList;
import de.jaggl.dto.lists.ShortList;
import de.jaggl.dto.lists.StringList;
import de.jaggl.utils.common.helpers.ReflectionHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="dto")
public final class Dto
implements Iterable<Map.Entry<String, Object>> {
    private LinkedHashMap<String, Object> data = new LinkedHashMap();

    public void put(String key, byte value) {
        this.putData(key, value);
    }

    public void put(String key, boolean value) {
        this.putData(key, value);
    }

    public void put(String key, short value) {
        this.putData(key, value);
    }

    public void put(String key, int value) {
        this.putData(key, value);
    }

    public void put(String key, long value) {
        this.putData(key, value);
    }

    public void put(String key, float value) {
        this.putData(key, Float.valueOf(value));
    }

    public void put(String key, double value) {
        this.putData(key, value);
    }

    public void put(String key, char value) {
        this.putData(key, Character.valueOf(value));
    }

    public void put(String key, String value) {
        this.putData(key, value);
    }

    public void put(String key, Date value) {
        this.putData(key, value != null ? new Date(value.getTime()) : null);
    }

    public void put(String key, Dto value) {
        this.putData(key, value);
    }

    public void put(String key, ByteList value) {
        this.putData(key, value);
    }

    public void put(String key, BooleanList value) {
        this.putData(key, value);
    }

    public void put(String key, ShortList value) {
        this.putData(key, value);
    }

    public void put(String key, IntegerList value) {
        this.putData(key, value);
    }

    public void put(String key, LongList value) {
        this.putData(key, value);
    }

    public void put(String key, FloatList value) {
        this.putData(key, value);
    }

    public void put(String key, DoubleList value) {
        this.putData(key, value);
    }

    public void put(String key, CharacterList value) {
        this.putData(key, value);
    }

    public void put(String key, StringList value) {
        this.putData(key, value);
    }

    public void put(String key, DtoList value) {
        this.putData(key, value);
    }

    public void put(String key, PrimitiveList value) {
        this.putData(key, value);
    }

    public void put(String key, byte ... values) {
        this.putData(key, new ByteList(values));
    }

    public void put(String key, boolean ... values) {
        this.putData(key, new BooleanList(values));
    }

    public void put(String key, short ... values) {
        this.putData(key, new ShortList(values));
    }

    public void put(String key, int ... values) {
        this.putData(key, new IntegerList(values));
    }

    public void put(String key, long ... values) {
        this.putData(key, new LongList(values));
    }

    public void put(String key, float ... values) {
        this.putData(key, new FloatList(values));
    }

    public void put(String key, double ... values) {
        this.putData(key, new DoubleList(values));
    }

    public void put(String key, char ... values) {
        this.putData(key, new CharacterList(values));
    }

    public void put(String key, String ... values) {
        this.putData(key, new StringList(values));
    }

    public void put(String key, Dto ... values) {
        this.putData(key, new DtoList(values));
    }

    public void put(String key, Object value) {
        if (value != null && !Dto.isAllowedType(value.getClass())) {
            throw new UnsupportedTypeException(value.getClass());
        }
        this.putData(key, value);
    }

    public void putNull(String key) {
        this.putData(key, null);
    }

    public Byte get(String key, byte defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Boolean get(String key, boolean defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Short get(String key, short defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Integer get(String key, int defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Long get(String key, long defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Float get(String key, float defaultValue) {
        return this.getData(key, Float.valueOf(defaultValue));
    }

    public Double get(String key, double defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Character get(String key, char defaultValue) {
        return this.getData(key, Character.valueOf(defaultValue));
    }

    public String get(String key, String defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Date get(String key, Date defaultValue) {
        return this.getData(key, defaultValue);
    }

    public Dto get(String key, Dto defaultValue) {
        return this.getData(key, defaultValue);
    }

    public List<Byte> get(String key, ByteList defaultValue) {
        return this.getList(key, defaultValue, ByteList.class);
    }

    public List<Boolean> get(String key, BooleanList defaultValue) {
        return this.getList(key, defaultValue, BooleanList.class);
    }

    public List<Short> get(String key, ShortList defaultValue) {
        return this.getList(key, defaultValue, ShortList.class);
    }

    public List<Integer> get(String key, IntegerList defaultValue) {
        return this.getList(key, defaultValue, IntegerList.class);
    }

    public List<Long> get(String key, LongList defaultValue) {
        return this.getList(key, defaultValue, LongList.class);
    }

    public List<Float> get(String key, FloatList defaultValue) {
        return this.getList(key, defaultValue, FloatList.class);
    }

    public List<Double> get(String key, DoubleList defaultValue) {
        return this.getList(key, defaultValue, DoubleList.class);
    }

    public List<Character> get(String key, CharacterList defaultValue) {
        return this.getList(key, defaultValue, CharacterList.class);
    }

    public List<String> get(String key, StringList defaultValue) {
        return this.getList(key, defaultValue, StringList.class);
    }

    public List<Dto> get(String key, DtoList defaultValue) {
        return this.getList(key, defaultValue, DtoList.class);
    }

    public List<Object> get(String key, PrimitiveList defaultValue) {
        return this.getList(key, defaultValue, PrimitiveList.class);
    }

    public List<Byte> get(String key, byte ... defaultValue) {
        return this.getList(key, new ByteList(defaultValue), ByteList.class);
    }

    public List<Boolean> get(String key, boolean ... defaultValue) {
        return this.getList(key, new BooleanList(defaultValue), BooleanList.class);
    }

    public List<Short> get(String key, short ... defaultValue) {
        return this.getList(key, new ShortList(defaultValue), ShortList.class);
    }

    public List<Integer> get(String key, int ... defaultValue) {
        return this.getList(key, new IntegerList(defaultValue), IntegerList.class);
    }

    public List<Long> get(String key, long ... defaultValue) {
        return this.getList(key, new LongList(defaultValue), LongList.class);
    }

    public List<Float> get(String key, float ... defaultValue) {
        return this.getList(key, new FloatList(defaultValue), FloatList.class);
    }

    public List<Double> get(String key, double ... defaultValue) {
        return this.getList(key, new DoubleList(defaultValue), DoubleList.class);
    }

    public List<Character> get(String key, char ... defaultValue) {
        return this.getList(key, new CharacterList(defaultValue), CharacterList.class);
    }

    public List<String> get(String key, String ... defaultValue) {
        return this.getList(key, new StringList(defaultValue), StringList.class);
    }

    public List<Dto> get(String key, Dto ... defaultValue) {
        return this.getList(key, new DtoList(defaultValue), DtoList.class);
    }

    public Byte getByte(String key) {
        return this.get(key, Byte.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Short getShort(String key) {
        return this.get(key, Short.class);
    }

    public Integer getInteger(String key) {
        return this.get(key, Integer.class);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Float getFloat(String key) {
        return this.get(key, Float.class);
    }

    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    public Character getCharacter(String key) {
        return this.get(key, Character.class);
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public Date getDate(String key) {
        return this.get(key, Date.class);
    }

    public Dto getDto(String key) {
        return this.get(key, Dto.class);
    }

    public List<Byte> getByteList(String key) {
        return this.getList(key, ByteList.class);
    }

    public List<Boolean> getBooleanList(String key) {
        return this.getList(key, BooleanList.class);
    }

    public List<Short> getShortList(String key) {
        return this.getList(key, ShortList.class);
    }

    public List<Integer> getIntegerList(String key) {
        return this.getList(key, IntegerList.class);
    }

    public List<Long> getLongList(String key) {
        return this.getList(key, LongList.class);
    }

    public List<Float> getFloatList(String key) {
        return this.getList(key, FloatList.class);
    }

    public List<Double> getDoubleList(String key) {
        return this.getList(key, DoubleList.class);
    }

    public List<Character> getCharacterList(String key) {
        return this.getList(key, CharacterList.class);
    }

    public List<String> getStringList(String key) {
        return this.getList(key, StringList.class);
    }

    public List<Dto> getDtoList(String key) {
        return this.getList(key, DtoList.class);
    }

    public List<Object> getPrimitiveList(String key) {
        return this.getList(key, PrimitiveList.class);
    }

    private void putData(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("a DTO-key mustn't be null");
        }
        this.data.put(key, value);
    }

    public <T> T get(String key, Class<T> type) {
        Object value = this.data.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return type.cast(value);
    }

    public <T> T getData(String key, T defaultValue) {
        if (!this.data.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.data.get(key);
        if (value == null) {
            return null;
        }
        if (!defaultValue.getClass().isAssignableFrom(value.getClass())) {
            throw new UnexpectedTypeException(defaultValue.getClass(), value.getClass());
        }
        return (T)defaultValue.getClass().cast(value);
    }

    private <T, E extends AbstractList<T>> List<T> getList(String key, Class<E> type) {
        Object value = this.data.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return (List)ReflectionHelper.getFieldData((Object)value, (String)"data");
    }

    private <T, E extends AbstractList<T>> List<T> getList(String key, E defaultValue, Class<E> type) {
        if (!this.data.containsKey(key)) {
            return (List)ReflectionHelper.getFieldData(defaultValue, (String)"data");
        }
        Object value = this.data.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new UnexpectedTypeException(type, value.getClass());
        }
        return (List)ReflectionHelper.getFieldData((Object)value, (String)"data");
    }

    public String toXml() {
        return XmlConverter.toXml(this);
    }

    public void toXml(OutputStream output) {
        XmlConverter.toXml(this, output);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public static Dto fromXml(String xml) {
        return XmlConverter.fromXml(xml);
    }

    public static Dto fromXml(InputStream input) {
        return XmlConverter.fromXml(input);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.data.entrySet().iterator();
    }

    public String toString() {
        return String.format("Dto %s", this.data);
    }

    public static boolean isAllowedType(Class<?> type) {
        return Byte.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || type.equals(Date.class) || Dto.class.isAssignableFrom(type) || ByteList.class.isAssignableFrom(type) || IntegerList.class.isAssignableFrom(type) || LongList.class.isAssignableFrom(type) || ShortList.class.isAssignableFrom(type) || DoubleList.class.isAssignableFrom(type) || FloatList.class.isAssignableFrom(type) || CharacterList.class.isAssignableFrom(type) || StringList.class.isAssignableFrom(type) || BooleanList.class.isAssignableFrom(type) || DateList.class.isAssignableFrom(type) || DtoList.class.isAssignableFrom(type);
    }
}

