package de.jaggl.dto.converters;

import static de.jaggl.dto.Dto.fromXml;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.springframework.amqp.core.MessageProperties;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

import de.jaggl.dto.Dto;

public class DtoMessageConverter implements MessageConverter, org.springframework.amqp.support.converter.MessageConverter
{
    @Override
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException
    {
        return session.createTextMessage(((Dto) object).toXml());
    }

    @Override
    public Object fromMessage(Message message) throws JMSException, MessageConversionException
    {
        return fromXml(((TextMessage) message).getText());
    }

    @Override
    public Object fromMessage(org.springframework.amqp.core.Message message) throws org.springframework.amqp.support.converter.MessageConversionException
    {
        return fromXml(new String(message.getBody()));
    }

    @Override
    public org.springframework.amqp.core.Message toMessage(Object object, MessageProperties messageProperties)
        throws org.springframework.amqp.support.converter.MessageConversionException
    {
        messageProperties.setContentType(MessageProperties.CONTENT_TYPE_XML);
        return new org.springframework.amqp.core.Message(((Dto) object).toXml().getBytes(), messageProperties);
    }
}