package de.jaggl.dto.lists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamImplicit;

public abstract class AbstractList<T>
{
    @XStreamImplicit
    protected ArrayList<T> data;

    public AbstractList(Collection<T> c)
    {
        this.data = new ArrayList<T>(c);
    }

    @SafeVarargs
    public AbstractList(T... values)
    {
        this.data = new ArrayList<T>(Arrays.asList(values));
    }

    public AbstractList()
    {
        this.data = new ArrayList<T>();
    }

    @Override
    public String toString()
    {
        return String.valueOf(data);
    }
}