package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("booleans")
public final class BooleanList extends AbstractList<Boolean>
{
    public BooleanList()
    {
        super();
    }

    public BooleanList(Collection<Boolean> c)
    {
        super(c);
    }

    public BooleanList(boolean... values)
    {
        super(toObjectList(values));
    }

    public void add(boolean value)
    {
        data.add(Boolean.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("BooleanList %s", super.toString());
    }
}