package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("chars")
public final class CharacterList extends AbstractList<Character>
{
    public CharacterList()
    {
        super();
    }

    public CharacterList(Collection<Character> c)
    {
        super(c);
    }

    public CharacterList(char... values)
    {
        super(toObjectList(values));
    }

    public void add(char value)
    {
        data.add(Character.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("CharList %s", super.toString());
    }
}