package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("doubles")
public final class DoubleList extends AbstractList<Double>
{
    public DoubleList()
    {
        super();
    }

    public DoubleList(Collection<Double> c)
    {
        super(c);
    }

    public DoubleList(double... values)
    {
        super(toObjectList(values));
    }

    public void add(double value)
    {
        data.add(Double.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("DoubleList %s", super.toString());
    }
}