package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("ints")
public final class IntegerList extends AbstractList<Integer>
{
    public IntegerList()
    {
        super();
    }

    public IntegerList(Collection<Integer> c)
    {
        super(c);
    }

    public IntegerList(int... values)
    {
        super(toObjectList(values));
    }

    public void add(int value)
    {
        data.add(Integer.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("IntList %s", super.toString());
    }
}