package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("longs")
public final class LongList extends AbstractList<Long>
{
    public LongList()
    {
        super();
    }

    public LongList(Collection<Long> c)
    {
        super(c);
    }

    public LongList(long... values)
    {
        super(toObjectList(values));
    }

    public void add(long value)
    {
        data.add(Long.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("LongList %s", super.toString());
    }
}