package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("shorts")
public final class ShortList extends AbstractList<Short>
{
    public ShortList()
    {
        super();
    }

    public ShortList(Collection<Short> c)
    {
        super(c);
    }

    public ShortList(short... values)
    {
        super(toObjectList(values));
    }

    public void add(short value)
    {
        data.add(Short.valueOf(value));
    }

    @Override
    public String toString()
    {
        return String.format("ShortList %s", super.toString());
    }
}