package de.jaggl.dto.lists;

import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("strings")
public final class StringList extends AbstractList<String>
{
    public StringList()
    {
        super();
    }

    public StringList(Collection<String> c)
    {
        super(c);
    }

    public StringList(String... values)
    {
        super(values);
    }

    public void add(String value)
    {
        data.add(value);
    }

    @Override
    public String toString()
    {
        return String.format("StringList %s", super.toString());
    }
}