/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import de.jaggl.dto.Dto;
import de.jaggl.dto.helpers.XmlConverter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

@XStreamAlias(value="dtoResponse")
public class DtoResponse {
    @XStreamAsAttribute
    private boolean success;
    @XStreamAsAttribute
    private Date timestamp;
    private Dto dto;
    private String error;

    public DtoResponse(Dto dto) {
        this.success = true;
        this.timestamp = new Date();
        this.dto = dto;
    }

    public DtoResponse(String error) {
        this.success = false;
        this.timestamp = new Date();
        this.error = error;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Dto getDto() {
        return this.dto;
    }

    public String getError() {
        return this.error;
    }

    public static DtoResponse fromXml(String xml) {
        return (DtoResponse)XmlConverter.fromXml(xml);
    }

    public static DtoResponse fromXml(InputStream input) {
        return (DtoResponse)XmlConverter.fromXml(input);
    }

    public String toXml() {
        return XmlConverter.toXml(this);
    }

    public void toXml(OutputStream output) {
        XmlConverter.toXml(this, output);
    }
}

