/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.dto.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapConverter
extends com.thoughtworks.xstream.converters.collections.MapConverter {
    public MapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type != null && type.equals(LinkedHashMap.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        for (Map.Entry entry : map.entrySet()) {
            String name = this.mapper().serializedClass(entry.getValue() != null ? entry.getValue().getClass() : null);
            writer.startNode(name);
            writer.addAttribute("key", entry.getKey().toString());
            if (entry.getValue() != null) {
                context.convertAnother(entry.getValue());
            }
            writer.endNode();
        }
    }

    protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        Class requiredType = this.mapper().realClass(reader.getNodeName());
        String key = reader.getAttribute("key");
        Object value = context.convertAnother((Object)map, requiredType);
        target.put(key, value);
    }
}

