package de.jaggl.dto;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import de.jaggl.dto.helpers.XmlConverter;
import de.jaggl.dto.lists.AbstractList;

@XStreamAlias("dtoResponse")
public class DtoResponse
{
    @XStreamAsAttribute
    private boolean success;

    @XStreamAsAttribute
    private Date timestamp;

    private Dto dto;

    private AbstractList<?> list;

    private String error;

    public DtoResponse(Dto dto)
    {
        success = true;
        timestamp = new Date();
        this.dto = dto;
    }

    public DtoResponse(AbstractList<?> list)
    {
        success = true;
        timestamp = new Date();
        this.list = list;
    }

    public DtoResponse(String error)
    {
        success = false;
        timestamp = new Date();
        this.error = error;
    }

    public boolean isSuccess()
    {
        return success;
    }

    public Date getTimestamp()
    {
        return timestamp;
    }

    public Dto getDto()
    {
        return dto;
    }

    public AbstractList<?> getList()
    {
        return list;
    }

    public String getError()
    {
        return error;
    }

    public static DtoResponse fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public static DtoResponse fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    public String toXml()
    {
        return XmlConverter.toXml(this);
    }

    public void toXml(OutputStream output)
    {
        XmlConverter.toXml(this, output);
    }
}