package de.jaggl.dto.converters;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

@SuppressWarnings("rawtypes")
public class MapConverter extends com.thoughtworks.xstream.converters.collections.MapConverter
{
    public MapConverter(Mapper mapper)
    {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type)
    {
        return (type != null) && (type.equals(LinkedHashMap.class));
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context)
    {
        Map map = (Map) source;
        for (Iterator iterator = map.entrySet().iterator(); iterator.hasNext();)
        {
            Map.Entry entry = (Map.Entry) iterator.next();
            String name = mapper().serializedClass(entry.getValue() != null ? entry.getValue().getClass() : null);
            writer.startNode(name);
            writer.addAttribute("key", entry.getKey().toString());
            if (entry.getValue() != null)
            {
                context.convertAnother(entry.getValue());
            }
            writer.endNode();
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target)
    {
        Class<?> requiredType = mapper().realClass(reader.getNodeName());
        String key = reader.getAttribute("key");
        Object value = context.convertAnother(map, requiredType);
        target.put(key, value);
    }
}