package de.jaggl.dto.helpers;

import static com.thoughtworks.xstream.XStream.PRIORITY_VERY_HIGH;

import java.io.InputStream;
import java.io.OutputStream;

import com.thoughtworks.xstream.XStream;

import de.jaggl.dto.Dto;
import de.jaggl.dto.DtoResponse;
import de.jaggl.dto.converters.DtoConverter;
import de.jaggl.dto.converters.MapConverter;
import de.jaggl.dto.lists.AbstractList;
import de.jaggl.dto.lists.BooleanList;
import de.jaggl.dto.lists.ByteList;
import de.jaggl.dto.lists.CharacterList;
import de.jaggl.dto.lists.DateList;
import de.jaggl.dto.lists.DoubleList;
import de.jaggl.dto.lists.DtoList;
import de.jaggl.dto.lists.FloatList;
import de.jaggl.dto.lists.IntegerList;
import de.jaggl.dto.lists.LongList;
import de.jaggl.dto.lists.PrimitiveList;
import de.jaggl.dto.lists.ShortList;
import de.jaggl.dto.lists.StringList;

public class XmlConverter
{
    private static XStream xStream;

    static
    {
        xStream = new XStream();
        xStream.registerConverter(new DtoConverter());
        xStream.registerConverter(new MapConverter(xStream.getMapper()), PRIORITY_VERY_HIGH);
        xStream.processAnnotations(new Class[]
        { Dto.class, ByteList.class, BooleanList.class, ShortList.class, IntegerList.class, LongList.class, FloatList.class, DoubleList.class,
            CharacterList.class, StringList.class, DateList.class, DtoList.class, PrimitiveList.class, DtoResponse.class });
    }

    public static String toXml(Dto dto)
    {
        return xStream.toXML(dto);
    }

    public static String toXml(AbstractList<?> list)
    {
        return xStream.toXML(list);
    }

    public static String toXml(DtoResponse dtoResponse)
    {
        return xStream.toXML(dtoResponse);
    }

    public static void toXml(Dto dto, OutputStream output)
    {
        xStream.toXML(dto, output);
    }

    public static void toXml(DtoResponse dtoResponse, OutputStream output)
    {
        xStream.toXML(dtoResponse, output);
    }

    public static void toXml(AbstractList<?> list, OutputStream output)
    {
        xStream.toXML(list, output);
    }

    @SuppressWarnings("unchecked")
    public static <T> T fromXml(InputStream input)
    {
        return (T) xStream.fromXML(input);
    }

    @SuppressWarnings("unchecked")
    public static <T> T fromXml(String xml)
    {
        return (T) xStream.fromXML(xml);
    }
}