package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("booleans")
public final class BooleanList extends AbstractList<Boolean>
{
    public BooleanList()
    {
        super();
    }

    public BooleanList(Collection<Boolean> c)
    {
        super(c);
    }

    public BooleanList(boolean... values)
    {
        super(toObjectList(values));
    }

    public void add(boolean value)
    {
        data.add(Boolean.valueOf(value));
    }

    public BooleanList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public BooleanList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("BooleanList %s", super.toString());
    }
}