package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("bytes")
public final class ByteList extends AbstractList<Byte>
{
    public ByteList()
    {
        super();
    }

    public ByteList(Collection<Byte> c)
    {
        super(c);
    }

    public ByteList(byte... values)
    {
        super(toObjectList(values));
    }

    public void add(byte value)
    {
        data.add(Byte.valueOf(value));
    }

    public ByteList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public ByteList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("ByteList %s", super.toString());
    }
}