package de.jaggl.dto.lists;

import static java.util.Arrays.asList;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("dates")
public final class DateList extends AbstractList<Date>
{
    public DateList()
    {
        super();
    }

    public DateList(Collection<Date> c)
    {
        super(getRealDates(c));
    }

    public DateList(Date... values)
    {
        super(getRealDates(values));
    }

    private static Collection<Date> getRealDates(Date[] values)
    {
        return getRealDates(asList(values));
    }

    private static Collection<Date> getRealDates(Collection<Date> values)
    {
        Collection<Date> dates = new ArrayList<Date>();
        for (Date date : values)
        {
            dates.add(date != null ? new Date(date.getTime()) : null);
        }
        return dates;
    }

    public void add(Date value)
    {
        data.add(value != null ? new Date(value.getTime()) : null);
    }

    public DateList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public DateList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("DateList %s", super.toString());
    }
}