package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("doubles")
public final class DoubleList extends AbstractList<Double>
{
    public DoubleList()
    {
        super();
    }

    public DoubleList(Collection<Double> c)
    {
        super(c);
    }

    public DoubleList(double... values)
    {
        super(toObjectList(values));
    }

    public void add(double value)
    {
        data.add(Double.valueOf(value));
    }

    public DoubleList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public DoubleList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("DoubleList %s", super.toString());
    }
}