package de.jaggl.dto.lists;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.Dto;
import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("dtos")
public final class DtoList extends AbstractList<Dto>
{
    public DtoList()
    {
        super();
    }

    public DtoList(Collection<Dto> c)
    {
        super(c);
    }

    public DtoList(Dto... values)
    {
        super(values);
    }

    public void add(Dto value)
    {
        data.add(value);
    }

    public DtoList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public DtoList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("DTOList %s", super.toString());
    }
}