package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("floats")
public final class FloatList extends AbstractList<Float>
{
    public FloatList()
    {
        super();
    }

    public FloatList(Collection<Float> c)
    {
        super(c);
    }

    public FloatList(float... values)
    {
        super(toObjectList(values));
    }

    public void add(float value)
    {
        data.add(Float.valueOf(value));
    }

    public FloatList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public FloatList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("FloatList %s", super.toString());
    }
}