package de.jaggl.dto.lists;

import static de.jaggl.utils.common.helpers.TypeHelper.toObjectList;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("shorts")
public final class ShortList extends AbstractList<Short>
{
    public ShortList()
    {
        super();
    }

    public ShortList(Collection<Short> c)
    {
        super(c);
    }

    public ShortList(short... values)
    {
        super(toObjectList(values));
    }

    public void add(short value)
    {
        data.add(Short.valueOf(value));
    }

    public ShortList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public ShortList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("ShortList %s", super.toString());
    }
}