package de.jaggl.dto.lists;

import java.io.InputStream;
import java.util.Collection;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import de.jaggl.dto.helpers.XmlConverter;

@XStreamAlias("strings")
public final class StringList extends AbstractList<String>
{
    public StringList()
    {
        super();
    }

    public StringList(Collection<String> c)
    {
        super(c);
    }

    public StringList(String... values)
    {
        super(values);
    }

    public void add(String value)
    {
        data.add(value);
    }

    public StringList fromXml(String xml)
    {
        return XmlConverter.fromXml(xml);
    }

    public StringList fromXml(InputStream input)
    {
        return XmlConverter.fromXml(input);
    }

    @Override
    public String toString()
    {
        return String.format("StringList %s", super.toString());
    }
}