/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.dto.lists;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import de.jaggl.dto.DtoResponse;
import de.jaggl.dto.helpers.XmlConverter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractList<T> {
    @XStreamImplicit
    protected ArrayList<T> data;

    public AbstractList(Collection<T> c) {
        this.data = new ArrayList<T>(c);
    }

    @SafeVarargs
    public AbstractList(T ... values) {
        this.data = new ArrayList<T>(Arrays.asList(values));
    }

    public AbstractList() {
        this.data = new ArrayList();
    }

    public DtoResponse toDtoResponse() {
        return new DtoResponse(this);
    }

    public String toXml() {
        return XmlConverter.toXml(this);
    }

    public void toXml(OutputStream output) {
        XmlConverter.toXml(this, output);
    }

    public String toString() {
        return String.valueOf(this.data);
    }
}

