/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.dto.lists;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.jaggl.dto.helpers.XmlConverter;
import de.jaggl.dto.lists.AbstractList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

@XStreamAlias(value="dates")
public final class DateList
extends AbstractList<Date> {
    public DateList() {
    }

    public DateList(Collection<Date> c) {
        super(DateList.getRealDates(c));
    }

    public DateList(Date ... values) {
        super(DateList.getRealDates(values));
    }

    private static Collection<Date> getRealDates(Date[] values) {
        return DateList.getRealDates(Arrays.asList(values));
    }

    private static Collection<Date> getRealDates(Collection<Date> values) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (Date date : values) {
            dates.add(date != null ? new Date(date.getTime()) : null);
        }
        return dates;
    }

    public void add(Date value) {
        this.data.add(value != null ? new Date(value.getTime()) : null);
    }

    public DateList fromXml(String xml) {
        return (DateList)XmlConverter.fromXml(xml);
    }

    public DateList fromXml(InputStream input) {
        return (DateList)XmlConverter.fromXml(input);
    }

    @Override
    public String toString() {
        return String.format("DateList %s", super.toString());
    }
}

